<?php

/**
 * Add an action that will register api routes
 */
add_action('rest_api_init', 'register_routes');

/**
 * Define function to get meny
 *
 * @return void
 * @author Alvin G. Kaburu <geekaburu@amprest.co.ke>
 */
function get_main_menu() 
{
    return wp_get_nav_menu_items('Main Menu');
}

/**
 * Add a function to register the route
 *
 * @return void
 * @author Alvin G. Kaburu <geekaburu@amprest.co.ke>
 */
function register_routes()
{
    register_rest_route('wp/v2/menus', 'main', [
        'methods' => 'GET',
        'callback' => 'get_main_menu',
    ]);
}